/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWValidationContext;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.base.VWString;
import filenet.vw.base.XMLHelper;
import filenet.ws.utils.WSSchemaValidator;
import filenet.ws.utils.WSSchemaValidatorResult;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public final class VWSchema
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 470L;
    private VWWorkflowDefinition myWorkflow;
    protected String m_Name = null;
    private String m_Schema = null;
    private String m_FileName = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-08 22:19:06 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_452_Int/PUI_460_Int/5 $";
    }

    protected VWSchema(VWWorkflowDefinition theWorkflow, String theName) throws VWException {
        if (theWorkflow == null) {
            throw new VWException("vw.api.VWSchemaInvalidWorkflow", "theWorkflow is invalid, (null).");
        }
        this.myWorkflow = theWorkflow;
        this.setName(theName);
    }

    public String getName() {
        return this.m_Name;
    }

    public String getSchema() {
        return this.m_Schema;
    }

    public void setSchema(String theSchema) {
        this.m_Schema = theSchema.trim();
    }

    public void setName(String theName) throws VWException {
        if (theName == null || theName.length() == 0) {
            throw new VWException("vw.api.VWSchemaInvalidName", "theName is invalid, (null or zero length).");
        }
        if (theName.equals(this.m_Name)) {
            return;
        }
        if (this.getWorkflowDefinition().isExistingSchemaName(theName)) {
            throw new VWException("vw.api.VWSchemaNameAlreadyExists", "theName is invalid, (a schema named {0} already exists in this workflow definition).", theName);
        }
        this.m_Name = theName;
    }

    public void validate(VWSession theSession, Vector EDefVector) throws VWException {
        VWValidationContext validationContext = new VWValidationContext(theSession, EDefVector);
        this.validate(validationContext);
    }

    protected void validate(VWValidationContext validationContext) throws VWException {
        VWValidationError theError;
        VWString theMessage;
        if (this.myWorkflow == null) {
            throw new VWException("vw.api.VWPartnerLinkDefinitionNullWorkflowRef", "No reference to containing workflow definition, runtime milestone definition, cannot validate.");
        }
        if (this.m_Schema == null || this.m_Schema.length() == 0) {
            theMessage = new VWString("vw.api.VWSchemaNullOrEmptySchema", "Schema is null or empty");
            theError = new VWValidationError(11, 1, this.m_Name, null, theMessage.toString(), null);
            validationContext.addValidationError(theError);
        }
        if (this.m_Schema != null && this.m_Schema.length() > 0 && !this.m_Schema.startsWith("<") && !Character.isLetterOrDigit(this.m_Schema.charAt(0))) {
            theMessage = new VWString("vw.api.VWSchemaBadSchema", "Schema must be a valid schema (starting with a \"<\" character) or a file name (starting with an alpha numeric character)");
            theError = new VWValidationError(11, 1, this.m_Name, this.m_Schema, theMessage.toString(), null);
            validationContext.addValidationError(theError);
        } else if (this.m_Schema != null && this.m_Schema.length() > 0 && this.m_Schema.startsWith("<")) {
            try {
                Document doc = XMLHelper.parseDocumentViaDOM(new InputSource(new StringReader(this.m_Schema)), null, null, false, false);
                Element SchemaEle = doc.getDocumentElement();
                String X = SchemaEle.getNodeName();
                if (!X.equals("schema") && !X.endsWith(":schema")) {
                    VWString theMessage2 = new VWString("vw.api.VWSchemaBadSchemaXMLNotSchema", "The first element of the schema XML is not named \"schema\", the xml is well formed, but it is not a schema definition.");
                    VWValidationError theError2 = new VWValidationError(11, 1, this.m_Name, this.m_Schema, theMessage2.toString(), null);
                    validationContext.addValidationError(theError2);
                }
            }
            catch (Exception e) {
                VWString theMessage3 = new VWString("vw.api.VWSchemaBadSchemaXML", "Error parsing the XML schema: {0}", e.getLocalizedMessage());
                VWValidationError theError3 = new VWValidationError(11, 1, this.m_Name, this.m_Schema, theMessage3.toString(), null);
                validationContext.addValidationError(theError3);
            }
            WSSchemaValidatorResult res = WSSchemaValidator.validate(new String[]{this.m_Name}, null, new String[]{this.m_Schema}, null);
            if (!res.getValid()) {
                String[] errors = res.getErrors();
                int nErrors = errors == null ? 0 : errors.length;
                for (int i = 0; i < nErrors; ++i) {
                    VWString theMessage4 = new VWString("vw.api.VWSchemaBadSchemaXMLSchemaValidationError", "Invalid Schema {0} : {1}", this.m_Name, errors[i]);
                    VWValidationError theError4 = new VWValidationError(11, 1, this.m_Name, this.m_Schema, theMessage4.toString(), null);
                    validationContext.addValidationError(theError4);
                }
            }
        } else if (this.m_Schema != null && this.m_Schema.length() > 0 && Character.isLetterOrDigit(this.m_Schema.charAt(0))) {
            if (this.m_Schema.length() > 2000) {
                theMessage = new VWString("vw.api.VWSchemaBadSchemaFileNameTooLong", "The schema is a file name and it exceeds 2000 characters in length (length is {0}).  Schema file names may not exceed 2000 characters in length", String.valueOf(this.m_Schema.length()));
                theError = new VWValidationError(11, 1, this.m_Name, this.m_Schema, theMessage.toString(), null);
                validationContext.addValidationError(theError);
            }
            if (this.m_Schema.indexOf("..") != -1) {
                theMessage = new VWString("vw.api.VWSchemaBadSchemaFileNameDotDot", "The schema is a file name and it contains the character sequence used to navigate to a parent directory, \"..\".  Schema file names may not contain \"..\"");
                theError = new VWValidationError(11, 1, this.m_Name, this.m_Schema, theMessage.toString(), null);
                validationContext.addValidationError(theError);
            }
            if (this.m_Schema.indexOf(58) != -1) {
                theMessage = new VWString("vw.api.VWSchemaBadSchemaFileNameColon", "The schema is a file name and it contains a colon, '':'', character.  Schema file names may not contain a colon character.");
                theError = new VWValidationError(11, 1, this.m_Name, this.m_Schema, theMessage.toString(), null);
                validationContext.addValidationError(theError);
            }
        }
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String ATTRIB_INDENT = "\t\t\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWSchemaNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("\t\t<schema");
        theBuffer.append("\n" + ATTRIB_INDENT + "name=\"" + VWXMLHandler.toXMLString(this.m_Name) + "\"");
        theBuffer.append("\n" + ATTRIB_INDENT + "schema=\"" + VWXMLHandler.toXMLString(this.m_Schema) + "\"");
        theBuffer.append("/>\n");
    }

    protected VWWorkflowDefinition getWorkflowDefinition() {
        return this.myWorkflow;
    }

    protected void setWorkflow(VWWorkflowDefinition theWorkflow) {
        this.myWorkflow = theWorkflow;
    }

    public String toString() {
        return this.m_Name;
    }

    public Object clone() {
        try {
            VWSchema ss = (VWSchema)super.clone();
            return ss;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getFileName() {
        return this.m_FileName;
    }

    protected void setFileName(String fName) {
        this.m_FileName = fName;
    }
}

